-- Scene Converter
-- Setup invalid ClassIDs for Physical Renderers workflow
-- the Render Upgrade Assistant is a tool to convert scenes to Physical Renderers, 
-- it can upgrade some of the Objects/Materials/Maps or remove them if they are unsupported.

-- Modify this file at your own risk !

SceneConverter.ClearInvalidclassIDs()

--Invalid Cameras
	--SceneConverter.AddInvalidClassID #eCamera #(0x1001, 0) --Free Camera ClassID
	--SceneConverter.AddInvalidClassID #eCamera #(0x1002, 0) --Target Camera ClassID

--Invalid Lights
	--SceneConverter.AddInvalidClassID #eLight #(0x1011, 0) --Omni Light classID
	--SceneConverter.AddInvalidClassID #eLight #(0x1012, 0) --Target Spot Light classID
	--SceneConverter.AddInvalidClassID #eLight #(0x1013, 0) --Target Directional Light classID
	--SceneConverter.AddInvalidClassID #eLight #(0x1014, 0) --Free Spot Light ClassID
	--SceneConverter.AddInvalidClassID #eLight #(0x1015, 0) --Free Directional Light ClassID
	--SceneConverter.AddInvalidClassID #eLight #(0x7bf61478, 0x522e4705) --Skylight
	if (false == NVIDIARenderersHelper.IsMentalrayDllPresent() ) do
	(
		--If the mental ray dll is not present, add its classes as invalid so we can convert or remove them
		SceneConverter.AddInvalidClassID #eLight #(0x0001b669, 0x000875c2) --mental ray Area Spot Light ClassID
		SceneConverter.AddInvalidClassID #eLight #(0x0001b669, 0x000875c1) --mental ray Area Omni Light ClassID
		SceneConverter.AddInvalidClassID #eLight #(0x335c655c, 0x382151b1) --mental ray SkyPortal Light classID
	)

--Invalid Geometries
	if (false == NVIDIARenderersHelper.IsMentalrayDllPresent() ) do
	(
		SceneConverter.AddInvalidClassID #eGeometry #(0x2e013bd5, 0x13c00afb) --mental ray Proxy Object ClassID
		SceneConverter.AddInvalidClassID #eGeometry #(0x711f0aad, 0x1c181b09) --mental ray Geometry Object ClassID
		SceneConverter.AddInvalidClassID #eGeometry #(0x64b11409, 0x1e7a186d) --iray Section Planes Object ClassID
	)
	
--Invalid Materials	
	if (false == NVIDIARenderersHelper.IsMentalrayDllPresent() ) do
	(
		SceneConverter.AddInvalidClassID #eMaterial #(0x70b05735, 0x4a163654) --mental ray Arch and Design Material ClassID
	)

--Invalid Maps	
	if (false == NVIDIARenderersHelper.IsMentalrayDllPresent() ) do
	(	
		SceneConverter.AddInvalidClassID #eMap #(0x7773161f, 0x996c7d15L) --mental ray Gamma and Gain	
		SceneConverter.AddInvalidClassID #eMap #(0x628e269e, 0x72386abf) --mental ray Physical sky environment map
	)
	
--Invalid Exposure Control
	if (false == NVIDIARenderersHelper.IsMentalrayDllPresent() ) do
	(
		SceneConverter.AddInvalidClassID #eOther #(0x73317331, 0x49154663) --mental ray Photographic Exposure Control
	)
	
--Other
	--SceneConverter.AddInvalidClassID #eOther #(0x4a1e6deb, 0x31c77d57) --Daylight Assembly